var MbPage = function(data){
    this.sourceData = data;

    this.frames = [];
    this.contents = [];
    this.activities = [];
    this.icons = [];

    this.parseData();

}

MbPage.prototype = {
    getId: function(){
        return this.sourceData['-id'];
    }
    ,parseData: function(){
        var me = this;
        for(var i = 0; i < this.sourceData.Frame.length; i++)
        {
            this.frames.push(new MbFrame(this.sourceData.Frame[i]));
        }

        for(var i = 0; i < this.sourceData.Icon.length; i++)
        {
            this.icons.push(new MbIcon(this.sourceData.Icon[i]));
        }

        for(var i = 0; i < this.sourceData.Content.length; i++)
        {
            this.contents.push(new MbContent(this.sourceData.Content[i]));
        }


        for(var i = 0; i < this.sourceData.Activity.length; i++)
        {
            var Activity = new MbActivity(this.sourceData.Activity[i]);
            this.activities.push(Activity);
            var framesIds = this.sourceData.Activity[i]['-frame_ref'].split(';');
            for(var j = 0; j < framesIds.length; j++ )
            {
                var Frame = this.getFrameById(framesIds[j]);
                if(Frame)
                {
//                    Activity.addFrame(Frame);
                    Frame.setActivity(Activity);
                }
            }

            if(this.sourceData.Activity[i]['-icon_ref'] != '')
            {
                var Icon = this.getIconById(this.sourceData.Activity[i]['-icon_ref']);
//                Icon.addActivity(Activity);
                Activity.setIcon(Icon);
            }

            if(typeof this.sourceData.Activity[i]['Content'] == 'object')
            {
                for(var j = 0; j < this.sourceData.Activity[i]['Content'].length; j++)
                {
                    var Content = this.getContentById(this.sourceData.Activity[i]['Content'][j]);
//                    Content.addActivity(Activity);
                    Activity.addContent(Content);
                }
            }
            else
            {
                var Content = this.getContentById(this.sourceData.Activity[i]['Content']);
//                Content.addActivity(Activity);
                Activity.addContent(Content);
            }


            Activity.getPage = function(){
                return me;
            }
        }
    }


    /**
     * Get activity by id
     * @param id
     * @returns MbActivity|null
     */
    ,getActivityById: function(id){
        var activity = null;
        for(var i = 0; i < this.activities.length; i++)
        {
            if(this.activities[i].getId() == id)
            {
                activity = this.activities[i];
                break;
            }
        }

        return activity;
    }

    ,getActivities: function(){
        return this.activities;
    }

    /**
     * Get content by id
     * @param id
     * @returns MbContent|null
     */
    ,getContentById: function(id){
        var content = null;
        for(var i = 0; i < this.contents.length; i++)
        {
            if(this.contents[i].getId() == id)
            {
                content = this.contents[i];
                break;
            }
        }

        return content;
    }

    ,getContents: function(){
        return this.contents;
    }

    /**
     * Get list of frames
     * @returns {Array}
     */
    ,getFrames: function(){
        return this.frames;
    }

    /**
     * Get Frame by id
     * @param id
     * @returns MbFrame|null
     */
    ,getFrameById: function(id){
        var frame = null;
        for(var i = 0; i < this.frames.length; i++)
        {
            if(this.frames[i].getId() == id)
            {
                frame = this.frames[i];
                break;
            }
        }

        return frame;
    }

    /**
     * Get icon by id
     * @param id
     * @returns MbIcon|null
     */
    ,getIconById: function(id){
        var icon = null;
        for(var i = 0; i < this.icons.length; i++)
        {
            if(this.icons[i].getId() == id)
            {
                icon = this.icons[i];
                break;
            }
        }

        return icon;
    }



    ,getNumber: function(){
        return this.sourceData['-number'];
    }


    ,getWidth: function(){
        return this.sourceData['-width'];
    }

    ,getHeight: function(){
        return this.sourceData['-height'];
    }
}